function StartRuinMod()

	RuinTableFunctions = {}
	RuinTableFunctions[Entities.PB_Brickworks1] = createBrickworkerRuin
	RuinTableFunctions[Entities.PB_Brickworks2] = createBrickworkerRuin
	RuinTableFunctions[Entities.PB_Sawmill1] = createSawmillRuin
	RuinTableFunctions[Entities.PB_Sawmill2] = createSawmillRuin
	RuinTableFunctions[Entities.PB_Farm1] = createFarmRuin
	RuinTableFunctions[Entities.PB_Farm2] = createFarmRuin
	RuinTableFunctions[Entities.PB_Farm3] = createFarmRuin
	RuinTableFunctions[Entities.PB_Residence1] = createResidenceRuin
	RuinTableFunctions[Entities.PB_Residence2] = createResidenceRuin
	RuinTableFunctions[Entities.PB_Residence3] = createResidenceRuin
	RuinTableFunctions[Entities.PB_Blacksmith1] = createBlacksmithRuin
	RuinTableFunctions[Entities.PB_Blacksmith2] = createBlacksmithRuin
	RuinTableFunctions[Entities.PB_Blacksmith3] = createBlacksmithRuin
	RuinTableFunctions[Entities.PB_Monastery1] = createChurchRuin
	RuinTableFunctions[Entities.PB_Monastery2] = createChurchRuin
	RuinTableFunctions[Entities.PB_Monastery3] = createChurchRuin
	RuinTableFunctions[Entities.PB_University1] = createUniversityRuin
	RuinTableFunctions[Entities.PB_University2] = createUniversityRuin
	RuinTableFunctions[Entities.PB_Beautification08] = createWellRuin
	RuinTableFunctions[Entities.PB_Tavern1] = createTavernRuin
	RuinTableFunctions[Entities.PB_Alchemist1] = createAlchemistRuin
	RuinTableFunctions[Entities.PB_Alchemist2] = createAlchemistRuin
	
	--[[
	9 Wohnhäuser          6%
	8 Bauernhöfe          8%
	1 Ziegelhütte         15%
	1 Sägemühle           10%
	1 Schmiede            35%
	1 Taverne             25%
	1 Universität         50%
	1 Hochschule          20%
	1 Alchemistenhütte    25%
	1 Kapelle             50%
	1 Festung             100%
	1 Dorfzentrum         100%
	1 Zugbrunnen 		  1%	 
	]]
	
	TownHPTable = {}
	TownHPTable["Citybuilding1"] = 10 	--Saegemuehle
	TownHPTable["Citybuilding2"] = 8	--Hof
	TownHPTable["Citybuilding3"] = 6	--Haus
	TownHPTable["Citybuilding4"] = 6	--Haus
	TownHPTable["Citybuilding5"] = 15	--Ziegler
	TownHPTable["Citybuilding6"] = 8	--Hof
	TownHPTable["Citybuilding7"] = 6	--Haus
	TownHPTable["Citybuilding8"] = 35	--Schmied
	TownHPTable["Citybuilding9"] = 8	--Hof
	TownHPTable["Citybuilding10"] = 6	--Haus
	TownHPTable["Citybuilding11"] = 8	--Hof
	TownHPTable["Citybuilding12"] = 6	--Haus
	TownHPTable["Citybuilding13"] = 6 	--Haus
	TownHPTable["Citybuilding14"] = 25 --Tavern
	TownHPTable["Citybuilding15"] = 6	--Haus
	TownHPTable["Citybuilding16"] = 6	--Haus
	TownHPTable["Citybuilding17"] = 8	--Hof
	TownHPTable["Citybuilding18"] = 8	--Hof
	TownHPTable["Citybuilding19"] = 50	--Uni
	TownHPTable["Citybuilding20"] = 8	--Hof
	TownHPTable["Citybuilding21"] = 50	--Kapelle
	TownHPTable["Citybuilding22"] = 25	--Alchi
	TownHPTable["Citybuilding23"] = 8	--Hof
	TownHPTable["Citybuilding24"] = 20	--Uni1
	TownHPTable["Citybuilding25"] = 8	--Hof
	TownHPTable["Citybuilding26"] = 6	--Haus
	TownHPTable["Citybuilding27"] = 1	--Zugbrunnen
	
	TowenHP = 100
	
	Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_DESTROYED,nil,"createRuin",1,nil,nil)
	
	GameCallback_OnBuildingUpgradeCompleteOld = GameCallback_OnBuildingUpgradeComplete
	GameCallback_OnBuildingUpgradeComplete = function(_OldID, _NewID)
		GameCallback_OnBuildingUpgradeCompleteOld(_OldID,_NewID)
		CheckForDestroied = _OldID
	end
	InitTownHPBalken()
	AddSaveLoadedCallback(InitTownHPBalken)
end

function createRuin()
	local entid = Event.GetEntityID()
	if entid == CheckForDestroied then
		return false
	else
		CheckForDestroied = nil
	end
	if Logic.IsEntityInCategory(entid, EntityCategories.Wall) == 1 and wallchanged then
		local WallPos = GetPosition(entid)
		local Orientation = Logic.GetEntityOrientation(entid)
		if Logic.GetEntityType(entid) == Entities.XD_WallStraight then
				Logic.CreateEntity(Entities.XD_RuinWall1,WallPos.X,WallPos.Y,Orientation,0)
		elseif Logic.GetEntityType(entid) == Entities.XD_WallDistorted then
			Logic.CreateEntity(Entities.XD_RuinWall3,WallPos.X,WallPos.Y,Orientation + 45,0)
		elseif Logic.GetEntityType(entid) == Entities.XD_WallCorner then
			Logic.CreateEntity(Entities.XD_RuinFragment1,WallPos.X,WallPos.Y,math.random(0,360),0)
		elseif Logic.GetEntityType(entid) == Entities.XD_WallStraightGate then
			if Orientation/90 == 1 or Orientation/90 == 3 then
				Logic.CreateEntity(Entities.XD_RuinFragment1,WallPos.X+300,WallPos.Y,math.random(0,360),0)
				Logic.CreateEntity(Entities.XD_RuinFragment1,WallPos.X-300,WallPos.Y,math.random(0,360),0)
			else
				Logic.CreateEntity(Entities.XD_RuinFragment1,WallPos.X,WallPos.Y+300,math.random(0,360),0)
				Logic.CreateEntity(Entities.XD_RuinFragment1,WallPos.X,WallPos.Y-300,math.random(0,360),0)
			end
		else
			assert(false,"Mauerteil unbekannt")
		end
		return false
	end
	local entname = Logic.GetEntityName(entid)
	if entname == nil or not string.find(entname,"Citybuilding") then
		if Logic.IsLeader(entid) == 1 and Logic.GetSector(entid) == 0 then
			local soldiersNumber = GetBugDeadLeaderSoldiersNumber(entid)
			local DieingPos = GetPosition(entid)
			MassAttackers[1]:AddLeader(AI.Entity_CreateFormation(Logic.EntityGetPlayer(entid), Logic.GetEntityType(entid), nil, soldiersNumber, DieingPos.X, DieingPos.Y, 0, 0, Logic.EntityGetPlayer(entid) == 1 and 0 or 3, 0))
		end
		return false
	end
	if entname == "HQ" or entname == "DZ" then
		return true
	end
	local buildingpos = GetPosition(entid)
	RuinTableFunctions[Logic.GetEntityType(entid)](buildingpos)
	CalcBalken(entname)
	
	return false
end

function GetBugDeadLeaderSoldiersNumber(_LeaderID)
	if HistoryFlag then
		return Int2Float(Logic.GetEntityScriptingValue(Event.GetEntityID(),39))
	else
		return Int2Float(Logic.GetEntityScriptingValue(Event.GetEntityID(),41))
	end
end

function CalcBalken(_gebaeudestring)
	TowenHP = TowenHP - TownHPTable[_gebaeudestring]
	if TowenHP <= 0 then
		XGUIEng.SetProgressBarValues("VCMP_Team1Progress", 0, 100)
		local randomcomment = math.random(1,7)
		Stream.Start("Sounds\\voicesmentor\\comment_badplay_rnd_0"..((randomcomment ~= 6 and randomcomment) or randomcomment-1)..".wav",150)
		if not SetDeafeatedAlready then
			StartSimpleJob("StartDefeatMessage")
		end
		return true
	else
		XGUIEng.SetProgressBarValues("VCMP_Team1Progress", TowenHP, 100)
	end
end

function StartDefeatMessage()
	SetDeafeatedAlready = true
	if not briefingIsActive and Counter.Tick2("DefeatCounter",7) then
		Defeat()
		return true
	end
	return false
end

function InitTownHPBalken()
	function GUIUpdate_VCTechRaceProgress()
		XGUIEng.SetMaterialColor("VCMP_Team1Progress", 0, 128, 0, 0, 255)
	end
	function GUIUpdate_VCTechRaceColor(_Player) end
	local barLength = 250
	local textBoxSize = 15
	local barHeight = 10
	local heightElement = 25
	XGUIEng.SetWidgetSize( "VCMP_Window", 252, 294)
	XGUIEng.ShowWidget("VCMP_Window", 1)
	XGUIEng.ShowAllSubWidgets( "VCMP_Window",1)
	XGUIEng.SetWidgetPosition( "VCMP_Window",0,112)
	
	for i = 1, 8 do
		for j = 1, 8 do
			XGUIEng.ShowWidget( "VCMP_Team"..i.."Player"..j, 0)
		end
		XGUIEng.SetWidgetSize( "VCMP_Team"..i, 252, 32)
		XGUIEng.SetWidgetSize( "VCMP_Team"..i.."Name", 252, 32)
		XGUIEng.ShowWidget( "VCMP_Team"..i.."_Shade", 0)
		XGUIEng.SetMaterialColor( "VCMP_Team"..i.."Name", 0, 0, 0, 0, 0) --hide BG by using alpha = 0s
		XGUIEng.ShowWidget( "VCMP_Team"..i.."PointGame", 0)

		
		-- manage progress bars
		XGUIEng.ShowWidget( "VCMP_Team"..i.."TechRace", 1)
		XGUIEng.ShowAllSubWidgets( "VCMP_Team"..i.."TechRace", 1)
		XGUIEng.SetWidgetSize( "VCMP_Team"..i.."TechRace", barLength, barHeight)
		XGUIEng.SetWidgetSize( "VCMP_Team"..i.."Progress", barLength, barHeight)
		XGUIEng.SetWidgetSize( "VCMP_Team"..i.."ProgressBG", barLength, barHeight)

		-- widget positions to set
		XGUIEng.SetWidgetPosition( "VCMP_Team"..i, 0, heightElement*(i-1))
		XGUIEng.SetWidgetPosition( "VCMP_Team"..i.."Name", 0, 0)
		XGUIEng.SetWidgetPosition( "VCMP_Team"..i.."TechRace", 0, textBoxSize)
	end
	for i = 2, 8 do 
		XGUIEng.ShowWidget("VCMP_Team"..i, 0);
		XGUIEng.ShowWidget("VCMP_Team"..i.."_Shade", 0);
	end
	XGUIEng.SetText("VCMP_Team1Name", "Zustand der Stadt");
	XGUIEng.SetMaterialColor("VCMP_Team1Progress", 0, 255, 102, 0, 255)
	XGUIEng.SetWidgetPosition( "VCMP_Team1Progress",2,3)
	XGUIEng.SetWidgetPosition( "VCMP_Team1ProgressBG",2,3)
	XGUIEng.SetProgressBarValues("VCMP_Team1Progress", TowenHP, 100)
	--XGUIEng.SetProgressBarValues("VCMP_Team1Progress", 100, 100)
	
end

function createResidenceRuin(_pos)
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X, _pos.Y, 0.00, 0);
	Logic.CreateEntity(Entities.XD_BoneAnimal1, _pos.X-137.96, _pos.Y-178.93, 302.70, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X-175.55, _pos.Y-137.96, 0.00, 0);
	Logic.CreateEntity(Entities.XD_BoneAnimal1, _pos.X+140.7, _pos.Y-236.94, 274.06, 0);
end

function createFarmRuin(_pos)
	if math.random(1,2) == 1 then 
		Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+14.64, _pos.Y+451.79, 270.00, 0), HistoryFlag and -29 or -33 , 1061997773) --[[ Scale: 0.80 ]]
		Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+36.61, _pos.Y+151.63, 0.00, 0), HistoryFlag and -29 or -33, 1058642330) --[[ Scale: 0.60 ]]
		Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+10, _pos.Y-290, 0.00, 0);
		Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-290, _pos.Y-190, 0.00, 0), HistoryFlag and -29 or -33, 1008981770)--[[ Scale: 0.01 ]]
		Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-290, _pos.Y-410, 0.00, 0), HistoryFlag and -29 or -33, 1008981770) --[[ Scale: 0.01 ]]
		Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-100, _pos.Y-410, 0.00, 0), HistoryFlag and -29 or -33, 1008981770) --[[ Scale: 0.01 ]]
		Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+106.97, _pos.Y-400.85, 0.00, 0), HistoryFlag and -29 or -33, 1008981770) --[[ Scale: 0.01 ]]
		Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X+140, _pos.Y-60, 28.65, 0);
		Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X+140, _pos.Y-260, 57.30, 0);
		Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-101.17, _pos.Y-95.7, 288.38, 0);
		Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-260, _pos.Y-440.86, 317.03, 0);
		Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-240, _pos.Y+160, 71.62, 0);
		Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-340, _pos.Y+440, 0.00, 0);
		Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-140, _pos.Y-240, 288.38, 0);
		Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinSmallTower1, _pos.X+40, _pos.Y+454.79, 100.00, 0),HistoryFlag and -29 or -33, 1059481190); --[[ Scale: 0.65 ]]
		Logic.CreateEntity(Entities.XD_Evil_Camp05, _pos.X-56.98, _pos.Y+265, 0.00, 0);
	else
		Logic.CreateEntity(Entities.XD_RuinWall5, _pos.X+22.70, _pos.Y+300.78, 90.00, 0);
		Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X+86.8, _pos.Y+113.92, 270.00, 0);
		Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinSmallTower3, _pos.X+48.09, _pos.Y+460.00, 71.62, 0), HistoryFlag and -29 or -33, 1062836634); --[[ Scale: 0.85 ]]
		Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+210.00, _pos.Y+90.00, 70.00, 0);
		Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+210.00, _pos.Y-190.00, 220.00, 0);
		Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-110.00, _pos.Y+190.00, 255.00, 0);
		Logic.CreateEntity(Entities.XD_MiscHaybale3, _pos.X+130.00, _pos.Y-28.54, 0.00, 0);
		Logic.CreateEntity(Entities.XD_MiscTrolley3, _pos.X+7.26, _pos.Y-70.00, 186.21, 0);
		Logic.CreateEntity(Entities.XD_Camp, _pos.X+62.74, _pos.Y+470.26, 0.00, 0);
		Logic.CreateEntity(Entities.XD_LargeCampFire, _pos.X+54.08, _pos.Y+438.15, 0.00, 0);
		Logic.CreateEntity(Entities.XD_Evil_Camp05, _pos.X-140.00, _pos.Y+352.55, 0.00, 0);
		Logic.CreateEntity(Entities.XD_BoneAnimal2, _pos.X-214.25, _pos.Y-23.01, 0.00, 0);
		Logic.CreateEntity(Entities.XD_BoneAnimal3, _pos.X-200.68, _pos.Y+90.55, 173.79, 0);
		Logic.CreateEntity(Entities.XD_Camp, _pos.X-157, _pos.Y+8.66, 274.06, 0);
	end
end

function createUniversityRuin(_pos)
	Logic.CreateEntity(Entities.XD_Evil_Camp05, _pos.X-650, _pos.Y-660, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp05, _pos.X-640, _pos.Y-240, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X-240, _pos.Y-440, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X-140.22, _pos.Y-460, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinSmallTower1, _pos.X+560, _pos.Y-240, 320.00, 0);
	Logic.CreateEntity(Entities.XD_RuinSmallTower1, _pos.X+560.00, _pos.Y+240, 20.00, 0);
	Logic.CreateEntity(Entities.XD_RuinSmallTower1, _pos.X+259.78, _pos.Y+260, 195.00, 0);
	Logic.CreateEntity(Entities.XD_RuinSmallTower1, _pos.X+259.78, _pos.Y-160, 200.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X+160, _pos.Y-360, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X-340, _pos.Y+160, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X+59.78, _pos.Y+240, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-174, _pos.Y-470, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+216.68, _pos.Y+409.61, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-126.97, _pos.Y+480.63, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-473.92, _pos.Y+450.3, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+375.86, _pos.Y-485.8, 0.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinHouse1, _pos.X+416.19, _pos.Y-1.34, 270.00, 0), HistoryFlag and -29 or -33, 1067450368) --[[ Scale: 1.25 ]]
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+380.94, _pos.Y+489.12, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+406.8, _pos.Y-495.69, 180.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+120.17,_pos.Y+484.88, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X-139.71, _pos.Y+487.2, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X-400.14, _pos.Y+491.84, 0.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinSmallTower1, _pos.X-540.22, _pos.Y+660, 155.00, 0), HistoryFlag and -29 or -33, 1060320051); --[[ Scale: 0.70 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinSmallTower1, _pos.X-540.22, _pos.Y+360, 250.00, 0), HistoryFlag and -29 or -33, 1060320051);--[[ Scale: 0.70 ]]
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+9.78, _pos.Y-390, 317.03, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-190, _pos.Y-490, 34.32, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-590.22, _pos.Y-290, 14.32, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-590, _pos.Y-610, 14.32, 0), HistoryFlag and -29 or -33, 1008981770) ; --[[ Scale: 0.01 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-90.22, _pos.Y-290, 14.32, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-390.22, _pos.Y-690, 14.32, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-90, _pos.Y-610, 14.32, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-390, _pos.Y-290, 14.32, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-240.22, _pos.Y-240, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-440, _pos.Y-440, 71.62, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-440, _pos.Y-140, 157.56, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-640, _pos.Y-360, 85.94, 0);
end

function createChurchRuin(_pos)
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-13.98, _pos.Y-477.57, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-388.52, _pos.Y-250.68, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+122.87, _pos.Y+8.23, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-328.44, _pos.Y+204.39, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X-660, _pos.Y+340, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X+40, _pos.Y-60, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp03, _pos.X+140, _pos.Y-560, 145.14, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp03, _pos.X-260, _pos.Y-560, 145.14, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X+440, _pos.Y+40, 171.89, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X+340, _pos.Y+240, 114.59, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X+240, _pos.Y+140, 114.59, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X+40, _pos.Y-160, 157.56, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-160, _pos.Y-360.00, 28.65, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X+40.00, _pos.Y-360, 42.97, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-160, _pos.Y-160, 317.03, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X+40.00, _pos.Y-60, 14.32, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-160, _pos.Y+240, 302.70, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-160, _pos.Y+40, 302.70, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X+40, _pos.Y+140, 0.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-428.27, _pos.Y-246.01, 180.00, 0), HistoryFlag and -29 or -33, 1061158912); --[[ Scale: 0.75 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-360.01, _pos.Y-230.71, 0.00, 0), HistoryFlag and -29 or -33, 1061158912); --[[ Scale: 0.75 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-229.24, _pos.Y-527.12, 270.00, 0), HistoryFlag and -29 or -33, 1061158912); --[[ Scale: 0.75 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-124.94, _pos.Y-488.66, 90.00, 0), HistoryFlag and -29 or -33, 1061158912); --[[ Scale: 0.75 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X+115.07, _pos.Y-523.54, 270.00, 0), HistoryFlag and -29 or -33, 1061158912); --[[ Scale: 0.75 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X+71.08, _pos.Y-488.66, 90.00, 0), HistoryFlag and -29 or -33, 1061158912); --[[ Scale: 0.75 ]]
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+490, _pos.Y+390, 0.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X+287.38, _pos.Y-359.29, 0.00, 0), HistoryFlag and -29 or -33, 1061158912); --[[ Scale: 0.75 ]]
	Logic.CreateEntity(Entities.XD_Evil_Camp03, _pos.X-660, _pos.Y-60, 145.14, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp03, _pos.X-60, _pos.Y+240, 231.08, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp03, _pos.X-60, _pos.Y-60, 288.38, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp03, _pos.X-560, _pos.Y-460, 245.41, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp03, _pos.X-560, _pos.Y-260, 245.41, 0);
	Logic.CreateEntity(Entities.XD_RuinMonastery1, _pos.X-51.73, _pos.Y+191.53, 0.00, 0);
end

function createBrickworkerRuin(_pos)
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-390, _pos.Y-410, 340.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X-60.00, _pos.Y+60, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X-152.2, _pos.Y+260, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp06, _pos.X-360, _pos.Y-360, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+115.78, _pos.Y+267.16, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X+217.85, _pos.Y-14.33, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X+148.58, _pos.Y-11.38, 180.00, 0)
	Logic.CreateEntity(Entities.XD_RuinWall5, _pos.X+65.96, _pos.Y-393.94, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-111.86, _pos.Y-353.65, 90.00, 0)
	Logic.CreateEntity(Entities.XD_RuinWall5, _pos.X+133.32, _pos.Y-438.91, 180.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-290, _pos.Y+107.85, 0.00, 0)
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-440, _pos.Y+357.85, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-438, _pos.Y+257.85, 270.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-440, _pos.Y+157.85, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-360, _pos.Y-40, 186.21, 0)
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-340, _pos.Y-260, 85.94, 0)
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-243.58, _pos.Y-140, 317.03, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+96.47, _pos.Y-410.61, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+94.97, _pos.Y-411.71, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+96.08, _pos.Y-413.21, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+76.54, _pos.Y+278.28, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-363.66, _pos.Y-387.69, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-297.08, _pos.Y+103.67, 0.00, 0);
end

function createWellRuin(_pos)
	Logic.CreateEntity(Entities.XD_Signpost1, _pos.X-92.97, _pos.Y-30, 340.00, 0);
	Logic.CreateEntity(Entities.XD_Signpost1, _pos.X+13.76, _pos.Y-78.44, 151.89, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinSmallTower3, _pos.X-40, _pos.Y-48.7, 0.00, 0), HistoryFlag and -29 or -33, 1057803469) --[[ Scale: 0.55 ]]
end

function createSawmillRuin(_pos)
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_Signpost2,_pos.X+330, _pos.Y+95.53, 90.00, 0), HistoryFlag and -29 or -33, 1069547520);--[[ Scale: 1.50 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_Signpost1, _pos.X+125.68, _pos.Y+70.00, 90.00, 0), HistoryFlag and -29 or -33, 1069547520); --[[ Scale: 1.50 ]]
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-401, _pos.Y-562.34, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-421.38, _pos.Y+585.85, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+246.07, _pos.Y-544.1, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+225.24, _pos.Y+485.74, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-8.78, _pos.Y+516.48, 0.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-290, _pos.Y+210, 0.00, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-392.67, _pos.Y+410, 0.00, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-160, _pos.Y-649.44, 317.03, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-160, _pos.Y-440, 28.65, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-354.42, _pos.Y+40.00, 345.68, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-440, _pos.Y+260, 42.97, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-109.67, _pos.Y+203.92, 345.68, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+290, _pos.Y-190, 42.97, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+110, _pos.Y+190, 85.94, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X+290, _pos.Y+195.03, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-410, _pos.Y+597.3, 28.65, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-402.01, _pos.Y-590, 274.06, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-390, _pos.Y-410, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+2.63, _pos.Y+477.85, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+191.43, _pos.Y+466.82, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+254.75, _pos.Y-506.72, 180.00, 0);
end

function createTavernRuin(_pos)
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+200, _pos.Y-50.00, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+200, _pos.Y-300, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X-191.97, _pos.Y+200, 270.00, 0);
	Logic.CreateEntity(Entities.XD_RuinResidence1, _pos.X+200, _pos.Y+200, 270.00, 0);
	Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X+202.67, _pos.Y-420.96, 270.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X+340, _pos.Y-340, 0.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinSmallTower1, _pos.X-360, _pos.Y+360, 0.00, 0), HistoryFlag and -29 or -33, 1059481190)--[[ Scale: 0.65 ]]
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-141.54, _pos.Y-42.34, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-340, _pos.Y-42.34, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-240, _pos.Y-140, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-160, _pos.Y-240, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-208.9, _pos.Y-10, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-310, _pos.Y-190, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-90, _pos.Y-96.09, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X+60.00, _pos.Y-544.83, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X+240, _pos.Y-540, 331.35, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-493.45, _pos.Y-290, 0.00, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-492.72, _pos.Y-510, 0.00, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-290, _pos.Y-490, 0.00, 0), HistoryFlag and -29 or -33, 1008981770); --[[ Scale: 0.01 ]]
end

function createBlacksmithRuin(_pos)
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinHouse1, _pos.X+83.18, _pos.Y-141.3, 0.00, 0), HistoryFlag and -29 or -33, 1061997773); --[[ Scale: 0.80 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinHouse1, _pos.X+81.24, _pos.Y+151.83, 0.00, 0), HistoryFlag and -29 or -33, 1061997773); --[[ Scale: 0.80 ]]
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinHouse1, _pos.X-134.71, _pos.Y+194.3, 0.00, 0), HistoryFlag and -29 or -33, 1058642330); --[[ Scale: 0.60 ]]
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-360, _pos.Y+260, 188.11, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-440, _pos.Y+340, 245.41, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment5, _pos.X-440, _pos.Y+160, 159.46, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-406.11, _pos.Y+10, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-210, _pos.Y-310, 166.76, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-410, _pos.Y-290, 286.76, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-169.7, _pos.Y+33.19, 0.00, 0);
	Logic.CreateEntity(Entities.XD_LargeCampFire, _pos.X-155.28, _pos.Y+55.33, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp07, _pos.X-60, _pos.Y-340, 0.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_Evil_Camp05, _pos.X-153.68, _pos.Y+43.15, 0.00, 0), HistoryFlag and -29 or -33, 1050253722); --[[ Scale: 0.30 ]]
end

function createAlchemistRuin(_pos)
	Logic.CreateEntity(Entities.XD_Evil_Camp04, _pos.X-210, _pos.Y-107.07, 112.69, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+61.29, _pos.Y+92.05, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+57.66, _pos.Y+87.61, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+56.12, _pos.Y+86.45, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X+55.14, _pos.Y+87.43, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-228.43, _pos.Y+635.73, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Camp, _pos.X-188.41, _pos.Y-567.8, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinSmallTower3,_pos.X-260, _pos.Y+646.16, 0.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinTower1, _pos.X+90.00, _pos.Y+92.93, 275.00, 0), HistoryFlag and -29 or -33, 1061997773); --[[ Scale: 0.80 ]]
	Logic.CreateEntity(Entities.XD_RuinSmallTower3, _pos.X-160, _pos.Y-557.07, 290.00, 0);
	Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-176.93, _pos.Y+487.41, 35.00, 0);
	Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-64.51, _pos.Y-174.17, 335.00, 0);
	Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-47.77, _pos.Y+296.04, 35.00, 0);
	Logic.CreateEntity(Entities.XD_RuinWall1, _pos.X-134.08, _pos.Y-317.51, 335.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-210, _pos.Y-91.93, 0.00, 0), HistoryFlag and -29 or -33, 1067030938); --[[ Scale: 1.20 ]]
	Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-110, _pos.Y+292.93, 85.00, 0);
	Logic.SetEntityScriptingValue(Logic.CreateEntity(Entities.XD_RuinFragment1, _pos.X-210, _pos.Y-107.07, 50.00, 0), HistoryFlag and -29 or -33, 1067030938); --[[ Scale: 1.20 ]]
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-260, _pos.Y+442.93, 0.00, 0);
	Logic.CreateEntity(Entities.XD_Evil_Camp06, _pos.X-160, _pos.Y+260, 0.00, 0);
	Logic.CreateEntity(Entities.XD_RuinFragment3, _pos.X-360, _pos.Y+442.93, 120.00, 0);
end

---------------------Utility

function qmod(a, b)
	return a - math.floor(a/b)*b
end

function Int2Float(num)
	if(num == 0) then
		return 0
	end

	local sign = 1

	if(num < 0) then
		num = 2147483648 + num
		sign = -1
	end

	local frac = qmod(num, 8388608)
	local headPart = (num-frac)/8388608
	local expNoSign = qmod(headPart, 256)
	local exp = expNoSign-127
	local fraction = 1
	local fp = 0.5
	local check = 4194304
	for i = 23, 0, -1 do
		if(frac - check) > 0 then
			fraction = fraction + fp
			frac = frac - check
		end
		check = check / 2
		fp = fp / 2
	end
	return fraction * math.pow(2, exp) * sign
end

function bitsInt(num)
	local t={}
	while num>0 do
		rest=qmod(num, 2)
		table.insert(t,1,rest)
		num=(num-rest)/2
	end
	table.remove(t, 1)
	return t
end

function bitsFrac(num, t)
	for i = 1, 48 do
		num = num * 2
		if(num >= 1) then
			table.insert(t, 1)
			num = num - 1
		else
			table.insert(t, 0)
		end
		if(num == 0) then
			return t
		end
	end
	return t
end

function Float2Int(fval)
	if(fval == 0) then
		return 0
	end

	local signed = false
	if(fval < 0) then
		signed = true
		fval = fval * -1
	end
	local outval = 0;
	local bits
	local exp = 0
	if fval >= 1 then
		local intPart = math.floor(fval)
		local fracPart = fval - intPart
		bits = bitsInt(intPart)
		exp = table.getn(bits)
		bitsFrac(fracPart, bits)
	else
		bits = {}
		bitsFrac(fval, bits)
		while(bits[1] == 0) do
			exp = exp - 1
			table.remove(bits, 1)
		end
		exp = exp - 1
		table.remove(bits, 1)
	end

	local bitVal = 4194304
	local start = 1

	for bpos = start, 23 do
		local bit = bits[bpos]
		if(not bit) then
			break;
		end

		if(bit == 1) then
			outval = outval + bitVal
		end
		bitVal = bitVal / 2
	end

	outval = outval + (exp+127)*8388608

	if(signed) then
		outval = outval - 2147483648
	end

	return outval;
end